#version 120
varying vec4 texcoord;
varying vec4 color;
varying vec4 lmcoord;
uniform float frameTimeCounter;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

attribute vec4 mc_Entity;

float wavyBlock(in float materialId){
  if(materialId == 18.0){
    return 0.3;
  }
  if(materialId == 59.0){
    return 0.3;
  }
  if(materialId == 83.0){
    return 0.2;
  }
  if(materialId == 106.0){
    return 0.2;
  }
  if(materialId == 161.0){
    return 0.3;
  }
  if(materialId == 31.0){
    return 0.3;
  }
  if(materialId == 175.0){
    return 0.3;
  }
  return 0.0;
}

float curve(float x)
{
	return tan(x);
}

float invcurve(float x, float curvature)
{
	return atan(x/curvature)*curvature;
}

void main() {
	vec4 position = gl_ModelViewMatrix * gl_Vertex;
	position = gbufferModelViewInverse * position;
	float curvature = 256;
	float dist = sqrt(position.z*position.z + position.x*position.x);

	float oma = curve(dist / curvature);
  float y = position.y;
	float z = invcurve(position.z, curvature) + (sin(frameTimeCounter + y)/10) * wavyBlock(mc_Entity.x);
	float x = invcurve(position.x, curvature) + (sin(frameTimeCounter + y + z)/10) * wavyBlock(mc_Entity.x);
	float xy = invcurve(dist, curvature);
	position.y = (xy*oma+y);
	position.x = x;
	position.z = z;

	position = gbufferModelView * position;
	gl_Position = gl_ProjectionMatrix * position;
	color = gl_Color;
	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	texcoord = gl_MultiTexCoord0;
}
